/***************************************************************
Copyright (c), 2015, TP-LINK Technologies CO.,LTD.

File name:	tplink_gpio.c
Version:		1.0
Description:	Tplink gpio driver on Mediatek platform.
	
Author:			zhouguofeng
Create Date:	2015-11-24

History:		01, 2015-11-24, zhouguofeng     Create.

***************************************************************/
#include <linux/init.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <asm/uaccess.h>
#include <linux/delay.h>

#include "ralink_gpio.h"
	
#include <asm/rt2880/surfboardint.h>
	
#ifdef  CONFIG_DEVFS_FS
#include <linux/devfs_fs_kernel.h>
	static	devfs_handle_t devfs_handle;
#endif

#include <generated/tplink_gpio_def.h>

#define NAME			"ralink_gpio"
#define TPLINK_GPIO_DEVNAME	"gpio"

int tplink_gpio_major = 252;

MODULE_DESCRIPTION("Ralink SoC GPIO Driver");
MODULE_AUTHOR("Winfred Lu <winfred_lu@ralinktech.com.tw>");
MODULE_LICENSE("GPL");


/*
 * IOCTL Command Codes
 */
#define	TP_MT7620_GPIO_IOCTL_BASE			0x01
#define	TP_MT7620_GPIO_IOCTL_CMD1      	    TP_MT7620_GPIO_IOCTL_BASE
#define	TP_MT7620_GPIO_IOCTL_CMD2      	    TP_MT7620_GPIO_IOCTL_BASE + 0x01
#define	TP_MT7620_GPIO_IOCTL_CMD3      	    TP_MT7620_GPIO_IOCTL_BASE + 0x02
#define	TP_MT7620_GPIO_IOCTL_CMD4      	    TP_MT7620_GPIO_IOCTL_BASE + 0x03
#define	TP_MT7620_GPIO_IOCTL_CMD5      	    TP_MT7620_GPIO_IOCTL_BASE + 0x04
#define	TP_MT7620_GPIO_IOCTL_CMD6      	    TP_MT7620_GPIO_IOCTL_BASE + 0x05
#define	TP_MT7620_GPIO_IOCTL_MAX			TP_MT7620_GPIO_IOCTL_CMD6
	
#define	TP_MT7620_GPIO_MAGIC 				0xB2
#define	TP_MT7620_GPIO_BTN_READ			    _IOR(TP_MT7620_GPIO_MAGIC, TP_MT7620_GPIO_IOCTL_CMD1, int)
#define	TP_MT7620_GPIO_LED_READ			    _IOR(TP_MT7620_GPIO_MAGIC, TP_MT7620_GPIO_IOCTL_CMD2, int)
#define	TP_MT7620_GPIO_LED_WRITE			_IOW(TP_MT7620_GPIO_MAGIC, TP_MT7620_GPIO_IOCTL_CMD3, int)


#define TP_MT7620_SYSCTL_ADDR					RALINK_SYSCTL_BASE	// system control
#define TP_MT7620_REG_GPIOMODE				(TP_MT7620_SYSCTL_ADDR + 0x60)

#define TP_MT7620_GPIOMODE_I2C_BIT_0			0
#define TP_MT7620_GPIOMODE_UARTF_BIT_2		2
#define TP_MT7620_GPIOMODE_UARTF_BIT_3		3
#define TP_MT7620_GPIOMODE_UARTF_BIT_4		4
#define TP_MT7620_GPIOMODE_RGMII1_BIT_9		9
#define TP_MT7620_GPIOMODE_WLED_BIT_13		13
#define TP_MT7620_GPIOMODE_WLED_BIT_12		12
#define TP_MT7620_GPIOMODE_EPHY_LED_BIT_15	15

#define TP_GPIO_MODE_VALUE 1

#if defined (CONFIG_RALINK_GPIO_IMPROVE_TPLINK)
#if defined (CONFIG_TPLINK_GPIO_RE350V1)
#define TP_GPIO_LED_ON					0
#define TP_GPIO_LED_OFF					1

#define TP_GPIO_RSSI_LED_ON				1
#define TP_GPIO_RSSI_LED_OFF			0


#define TP_GPIO_BUTTON_PRESS			0	// Button has be pressed


/* GPIO Pin DIR valid value */
#define TP_GPIO_DIR_OUT_VALUE			1
#define TP_GPIO_DIR_IN_VALUE			0

/* GPIO STATUS FOR Application */
#define LED_ON							1	//light
#define LED_OFF							0
#define BUTTON_PRESS					1	//press
#define BUTTON_UNPRESS					0

#elif defined (CONFIG_TPLINK_GPIO_WPA4530V1) || defined (CONFIG_TPLINK_GPIO_WPA4220V3)
#define TP_GPIO_LED_ON					0
#define TP_GPIO_LED_OFF				1

#define TP_GPIO_RSSI_LED_ON				1
#define TP_GPIO_RSSI_LED_OFF			0


/* Button GPIO Pin adn valid value, this is input mode */
#define TP_GPIO_BUTTON_PRESS			0	// Button has be pressed


/* GPIO Pin DIR valid value */
#define TP_GPIO_DIR_OUT_VALUE			1
#define TP_GPIO_DIR_IN_VALUE			0

/* GPIO STATUS FOR Application */
#define LED_ON							1	//light
#define LED_OFF							0
#define BUTTON_PRESS					1	//press
#define BUTTON_UNPRESS					0


#define PLC_PORT 0
#define TPLINK_GPIO_VALUE_CLR 0
#endif
static u32 tplink_reg_read(u32 addr)
{
	u32 value;
	
	value = le32_to_cpu(*(volatile u32 *)(addr));
	
	return value;
}

void tplink_reg_write(volatile u32 addr, u32 value)
{	
	*(volatile u32 *)(addr) = cpu_to_le32(value);

	return ;
}

u32 tplink_gpio_set_bit(int pos, int bitvalue, u32 in_value)
{
	u32 mask = 1 << pos;
	u32 out_value = in_value;
	if (bitvalue)
		out_value |= mask;
	else
		out_value &= ~mask;

	return out_value;
}


int tplink_gpio_dir_reg_offset(int dirPin)
{	
#if defined (CONFIG_TPLINK_GPIO_RE350V1)	\
	|| defined (CONFIG_TPLINK_GPIO_WPA4220V3)
	return (dirPin % 32);
#elif defined (CONFIG_TPLINK_GPIO_WPA4530V1)
		u32 ret = 0;
	
	if (dirPin<= 23)
	{
		ret = dirPin;
	}
	else if (dirPin >=24 && dirPin<= 39)
	{
		ret = dirPin - 24;
	}
	else if (dirPin >=40 && dirPin<= 71)
	{
		ret = dirPin - 40;
	}
	else if(dirPin >= 72)
	{
		ret = dirPin - 72;
	}
	
	return ret;
#endif
}
u32 tplink_gpio_dir_addr(int dirPin)
{
#if defined (CONFIG_TPLINK_GPIO_RE350V1) \
	|| defined (CONFIG_TPLINK_GPIO_WPA4220V3)
	return (RALINK_REG_PIODIR + (dirPin / 32) * 4);
#elif defined (CONFIG_TPLINK_GPIO_WPA4530V1)
	u32 ret = 0;
	
	if (dirPin<= 23)
	{
		ret=RALINK_REG_PIODIR;
	}
	else if (dirPin >=24 && dirPin<= 39)
	{
		ret = RALINK_REG_PIO3924DIR;
	}
	else if (dirPin >=40 && dirPin<= 71)
	{
		ret = RALINK_REG_PIO7140DIR;
	}
	else if(dirPin >= 72)
	{
		ret = RALINK_REG_PIO72DIR;
	}	
	return ret;
#endif
}

void tplink_gpio_dirreg_set(int dirPin, int pinValue)
{	
	u32 gpioDir;
	u32 dirAddr;
	dirAddr = tplink_gpio_dir_addr(dirPin);
	//if (dirAddr)
	{			
		gpioDir = tplink_reg_read(dirAddr);
		gpioDir = tplink_gpio_set_bit(tplink_gpio_dir_reg_offset(dirPin),
									   pinValue, gpioDir);
		tplink_reg_write(dirAddr, gpioDir);
	}
	
	printk("pin:%d, addr: %x, value:%x, offset:%d\n", dirPin,
			dirAddr, gpioDir, tplink_gpio_dir_reg_offset(dirPin));
	return ;	
}

void tplink_gpio_dir_set(void)
{	
#if 0
	int outPin[TP_GPIO_OUTMODE_NUMBER] = {
					TP_GPIO_POWER_LED_PIN, 
					TP_GPIO_WLAN_2G_LED_PIN, 
					TP_GPIO_WLAN_5G_LED_PIN,
					TP_GPIO_RSSI_RED_LED_PIN, 
					TP_GPIO_RSSI_BLUE_LED_PIN, 
					TP_GPIO_LAN_LINK_LED_PIN,
					TP_GPIO_LAN_SPEED_LED_PIN
				};
	int inPin[TP_GPIO_INMODE_NUMBER] = {
					TP_GPIO_RE_BUTTON_PIN,
					GPIO_BTN_PORT_LED_SWITCH,
					GPIO_BTN_PORT_RESET,
					TP_GPIO_POWER_BUTTON_PIN
				};	
	int i = 0;	

	//set the Pin as output mode
	for (i = 0; i < TP_GPIO_OUTMODE_NUMBER; i++)
	{
		tplink_gpio_dirreg_set(outPin[i], TP_GPIO_DIR_OUT_VALUE);
/*
		dirAddr = tplink_gpio_dir_addr(outPin[i]);
		//if (dirAddr)
		{			
			gpioDir = tplink_reg_read(dirAddr);
			gpioDir = tplink_gpio_set_bit(tplink_gpio_dir_reg_offset(outPin[i]),
										   TP_GPIO_DIR_OUT_VALUE, gpioDir);
			tplink_reg_write(dirAddr, gpioDir);
		}
*/		
	}

	//set the Pin as input mode
	for (i = 0; i < TP_GPIO_INMODE_NUMBER; i++)
	{
		tplink_gpio_dirreg_set(inPin[i], TP_GPIO_DIR_IN_VALUE);
/*
		dirAddr = tplink_gpio_dir_addr(inPin[i]);
		//if (dirAddr)
		{
			gpioDir = tplink_reg_read(dirAddr);
			gpioDir= tplink_gpio_set_bit(tplink_gpio_dir_reg_offset(inPin[i]),
										TP_GPIO_DIR_IN_VALUE, gpioDir); 		
			tplink_reg_write(dirAddr, gpioDir);
			
			printk("i:%d, pin:%d, addr: %x, value:%x, offset:%d\n", i, inPin[i],
				dirAddr, gpioDir, tplink_gpio_dir_reg_offset(inPin[i]));
		}
*/
	}
	
	return ;
#endif
}

void tplink_gpio_mode_reg_set(void)
{
	u32 gpioMode;
#if defined (CONFIG_TPLINK_GPIO_RE350V1)
	gpioMode = tplink_reg_read(RALINK_REG_GPIOMODE);
	gpioMode |= RALINK_GPIOMODE_WDT | RALINK_GPIOMODE_GE2;
	tplink_reg_write(RALINK_REG_GPIOMODE, gpioMode);
#endif

#if defined (CONFIG_TPLINK_GPIO_WPA4530V1)

	gpioMode = tplink_reg_read(TP_MT7620_REG_GPIOMODE);

	/* Note here by xiongliuzhong, 28Mar13, i2c mode is bit0 in datasheet, gpio mode */
	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_I2C_BIT_0,
					   TP_GPIO_MODE_VALUE,
					   gpioMode);

	/* set bit[2-4] UARTF, GPIO7-14 as gpio */
	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_UARTF_BIT_2, 
					   TP_GPIO_MODE_VALUE,
					   gpioMode);
	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_UARTF_BIT_3,
					   TP_GPIO_MODE_VALUE,
					   gpioMode);
	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_UARTF_BIT_4,
					   TP_GPIO_MODE_VALUE,
					   gpioMode);

	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_RGMII1_BIT_9,
					   TP_GPIO_MODE_VALUE,
					   gpioMode);
	
	gpioMode = tplink_gpio_set_bit(TP_MT7620_GPIOMODE_UARTF_BIT_2, 
					   TP_GPIO_MODE_VALUE,
					   gpioMode);

	tplink_reg_write(TP_MT7620_REG_GPIOMODE, gpioMode);
#elif defined (CONFIG_TPLINK_GPIO_WPA4220V3)
	/* todo */
#endif
	return ;
}
/*
	the api of gpio data registers:
*/
int tplink_gpio_data_reg_offset(int dataPin)
{	
#if defined (CONFIG_TPLINK_GPIO_RE350V1) \
	|| defined (CONFIG_TPLINK_GPIO_WPA4220V3)
	return (dataPin % 32);
#elif defined (CONFIG_TPLINK_GPIO_WPA4530V1)
	u32 ret = 0;
	
	if (dataPin<= 23)
	{
		ret = dataPin;
	}
	else if (dataPin >=24 && dataPin<= 39)
	{
		ret = dataPin - 24;
	}
	else if (dataPin >=40 && dataPin<= 71)
	{
		ret = dataPin - 40;
	}
	else if(dataPin >= 72)
	{
		ret = dataPin - 72;
	}
	
	return ret;
#endif
}

u32 tplink_gpio_data_addr(int dataPin)
{
#if defined (CONFIG_TPLINK_GPIO_RE350V1) \
	|| defined (CONFIG_TPLINK_GPIO_WPA4220V3)
	return (RALINK_REG_PIODATA+ (dataPin / 32) * 4);
#elif defined (CONFIG_TPLINK_GPIO_WPA4530V1)
	u32 ret = 0;
	
	if (dataPin<= 23)
	{
		ret=RALINK_REG_PIODATA;
	}
	else if (dataPin >=24 && dataPin<= 39)
	{
		ret = RALINK_REG_PIO3924DATA;
	}
	else if (dataPin >=40 && dataPin<= 71)
	{
		ret = RALINK_REG_PIO7140DATA;
	}
	else if(dataPin >= 72)
	{
		ret = RALINK_REG_PIO72DATA;
	}
	
	return ret;
#endif
}

static void tplink_gpio_print_all_register(void)
{
#if defined (CONFIG_TPLINK_GPIO_WPA4530V1)
	printk("[%s]read reg TP_MT7620_REG_GPIOMODE [0x%x] value[0x%x]\n\n",__FUNCTION__,TP_MT7620_REG_GPIOMODE,tplink_reg_read(TP_MT7620_REG_GPIOMODE));

	printk("[%s]read reg RALINK_REG_PIODIR [0x%x] value[0x%x]\n",__FUNCTION__,RALINK_REG_PIODIR,tplink_reg_read(RALINK_REG_PIODIR));
	printk("[%s]read reg RALINK_REG_PIODATA [0x%x] value[0x%x]\n\n",__FUNCTION__,RALINK_REG_PIODATA,tplink_reg_read(RALINK_REG_PIODATA));
	
	printk("[%s]read reg RALINK_REG_PIO3924DIR [0x%x] value[0x%x]\n",__FUNCTION__,RALINK_REG_PIO3924DIR,tplink_reg_read(RALINK_REG_PIO3924DIR));
	printk("[%s]read reg RALINK_REG_PIO3924DATA [0x%x] value[0x%x]\n\n",__FUNCTION__,RALINK_REG_PIO3924DATA,tplink_reg_read(RALINK_REG_PIO3924DATA));
	
	printk("[%s]read reg RALINK_REG_PIO7140DIR [0x%x] value[0x%x]\n",__FUNCTION__,RALINK_REG_PIO7140DIR,tplink_reg_read(RALINK_REG_PIO7140DIR));
	printk("[%s]read reg RALINK_REG_PIO7140DATA [0x%x] value[0x%x]\n\n",__FUNCTION__,RALINK_REG_PIO7140DATA,tplink_reg_read(RALINK_REG_PIO7140DATA));

	printk("[%s]read reg RALINK_REG_PIO72DIR [0x%x] value[0x%x]\n",__FUNCTION__,RALINK_REG_PIO72DIR,tplink_reg_read(RALINK_REG_PIO72DIR));
	printk("[%s]read reg RALINK_REG_PIO72DATA [0x%x] value[0x%x]\n\n",__FUNCTION__,RALINK_REG_PIO72DATA,tplink_reg_read(RALINK_REG_PIO72DATA));
#elif defined (CONFIG_TPLINK_GPIO_WPA4220V3)

#endif

}

int tplink_gpio_datareg_read(unsigned int pin)
{
	
	u32 regValue;
	u32 mask;
	u32 offset;


	offset = tplink_gpio_data_reg_offset(pin);
	regValue = tplink_reg_read(tplink_gpio_data_addr(pin));
	
	mask = 1 << offset;

	//tplink_gpio_print_all_register();
	
	return ((regValue & mask) >> offset);
}

void tplink_gpio_datareg_set(int dataPin, int pinValue)
{	
	u32 gpioData;
	//if (dirAddr)
	{			
		gpioData = tplink_reg_read(tplink_gpio_data_addr(dataPin));
		gpioData = tplink_gpio_set_bit(tplink_gpio_data_reg_offset(dataPin),
									   pinValue, gpioData);
		tplink_reg_write(tplink_gpio_data_addr(dataPin), gpioData);
	}
#if 0
#define CHECK_GPIO_CHANGE(pin) do { \
	static int v = TP_GPIO_LED_OFF; \
	if (dataPin == pin) \
	{ \
		if (v != pinValue) \
		{ \
			printk ("GPIO#%d %d -> %d \n", dataPin, v, pinValue); \
			v = pinValue; \
		} \
	} \
} while (0)

	
	CHECK_GPIO_CHANGE(37);
	CHECK_GPIO_CHANGE(43);	
#endif
	return ;	
}

void tplink_gpio_ethernet_led_set(int on)
{
	if (on & ~(1<<PLC_PORT))//port 0 for PLC ignore
	{	
		tplink_gpio_datareg_set(GPIO_LED_PORT_ETHERNET,TP_GPIO_LED_ON);

	}
	else
	{
		tplink_gpio_datareg_set(GPIO_LED_PORT_ETHERNET,TP_GPIO_LED_OFF);
	}
}


#define RAETH_GET_ALL_LINK_STATUS    0XFF

static unsigned int esw_get_link_status(unsigned int port_no)
{
    unsigned long reg_val, mask;
    unsigned long link_status = 0;
    int i = 0;

    if (RAETH_GET_ALL_LINK_STATUS == port_no) {
#if defined (CONFIG_RALINK_RT6855) || defined(CONFIG_RALINK_RT6855A) || \
    defined(CONFIG_RALINK_MT7620)
        for (i = 1; i < 4; i++){
            reg_val = *((volatile u32 *)(RALINK_ETH_SW_BASE+ 0x3008 + (i*0x100)));
            link_status |= (reg_val & 0x1) << i;
        }
#else
		reg_val = *((volatile u32 *)(RALINK_ETH_SW_BASE + 0x80));
/*
#ifdef CONFIG_WAN_AT_P0
		mask = 0xf << 26;
#else
		mask = 0xf << 25;
#endif /* CONFIG_WAN_AT_P0 */


		mask = 0x1f << 25;
		link_status = reg_val & mask;
#endif /* CONFIG_RALINK_RT6855 || CONFIG_RALINK_RT6855A || CONFIG_RALINK_MT7620 */

    }
    else {
#if defined (CONFIG_RALINK_RT6855) || defined(CONFIG_RALINK_RT6855A) || \
			defined(CONFIG_RALINK_MT7620)
        reg_val = *((volatile u32 *)(RALINK_ETH_SW_BASE+ 0x3008 + (port_no*0x100)));
        link_status |= (reg_val & 0x1) << port_no;
#else
		reg_val = *((volatile u32 *)(RALINK_ETH_SW_BASE + 0x80));

		link_status = reg_val & (1 << (port_no + 25));
#endif /* CONFIG_RALINK_RT6855 || CONFIG_RALINK_RT6855A || CONFIG_RALINK_MT7620 */
    }

 //   printk("port_no:%x, link status:%x.\n", port_no, link_status);
    return link_status;
}

static u32 tplink_gpio_ethernet_led_get(void)
{
	u32  status=0;

#if defined(CONFIG_TPLINK_GPIO_WPA4220V3)
	u32 port_use_except_plc_mask = 3 << 3; /* port: on_use, plc, no_use, lan1, lan2 */
	int i;
	for (i = 0; i < 5; ++i)
	{
		if (port_use_except_plc_mask & (1 << i))
		{
			status |= esw_get_link_status(i);
		}
	}

#else
	status=esw_get_link_status(RAETH_GET_ALL_LINK_STATUS);
#endif

	return status;
}

/*
	the api of GPIO IOCTL:
*/

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,35)
long tplink_gpio_ioctl(struct file *file, unsigned int req,
		unsigned long arg)
#else
int tplink_gpio_ioctl(struct inode *inode, struct file *file, unsigned int req,
		unsigned long arg)
#endif	
{
	int buttonStat = BUTTON_UNPRESS;
	int* argp = (int *)arg;
	//printk("set the gpio: %u, arg: %u\n", req, arg);
#if 0
	if (_IOC_TYPE(req) != TP_MT7620_GPIO_MAGIC ||
		_IOC_NR(req) < TP_MT7620_GPIO_IOCTL_BASE ||
		_IOC_NR(req) > TP_MT7620_GPIO_IOCTL_MAX)
	{
		printk("type:%d nr:%d\n", _IOC_TYPE(req), _IOC_NR(req));
		printk("mt7620_gpio_ioctl:unknown command\n");
		return -1;	
	}
#endif

	switch(req)
	{
	case GPIO_MAX:
		break;
	/* LED GPIO */
#ifdef GPIO_LED_PORT_SYS
	case GPIO_LED_PORT_SYS:
#endif

#ifdef GPIO_LED_PORT_WIFI_2G_AP
	case GPIO_LED_PORT_WIFI_2G_AP:
#endif

#ifdef GPIO_LED_PORT_WIFI_5G_AP
	case GPIO_LED_PORT_WIFI_5G_AP:
#endif

#ifdef GPIO_LED_PORT_ETHERNET
	case GPIO_LED_PORT_ETHERNET:
#endif

#ifdef GPIO_LED_PORT_LED_CONTROL
	case GPIO_LED_PORT_LED_CONTROL:
#endif		
		if ((*argp) == LED_ON)
			tplink_gpio_datareg_set(req, TP_GPIO_LED_ON);
		else				
			tplink_gpio_datareg_set(req, TP_GPIO_LED_OFF);
		break;
#if 0
	case TP_GPIO_RSSI_RED_LED_PIN: 		
		if ((*argp) == LED_ON)
			tplink_gpio_datareg_set(req, TP_GPIO_RSSI_LED_ON);
		else				
			tplink_gpio_datareg_set(req, TP_GPIO_RSSI_LED_OFF);
		break;
#endif
	/* Button GPIO, which the vaule of the gpios is be read*/
#ifdef GPIO_BTN_PORT_WIFI
	case GPIO_BTN_PORT_WIFI:
#endif
#ifdef GPIO_BTN_PORT_LED_SWITCH
	case GPIO_BTN_PORT_LED_SWITCH:
#endif
#ifdef GPIO_BTN_PORT_RESET
	case GPIO_BTN_PORT_RESET:
#endif
#ifdef GPIO_BTN_PORT_PAIR
	case GPIO_BTN_PORT_PAIR:
#endif
#if 0	
/* if eth port be up, it will do hardware switch reset. then impulse voltage will
** affect the value of gpio port. so will check the resetting and wait it finished.
** added by humin 2015.10.13
*/
		rstCtlReg = tplink_reg_read(RALINK_SYSCTL_BASE + 0x34);
		while (rstCtlReg & (0x1 << 2))
		{
			udelay(2000);
			printk("(%s-%d)rstCtlReg: %x, bit2: %d Hardware reset Switch, Now waitting it .... \n", 
				__FUNCTION__, __LINE__, rstCtlReg, (rstCtlReg & (0x1 << 2)));
			rstCtlReg = tplink_reg_read(RALINK_SYSCTL_BASE + 0x34);
			waitCnt++;
			if (waitCnt > 10)
			{
				printk("(%s-%d)Error, Hardware switch reset error!\n", __FUNCTION__, __LINE__);
				return -1;
			}
		}
#endif
		//printk("\n[kernel]Get the gpio pin: %d\n", req);

		if (tplink_gpio_datareg_read(req) == TP_GPIO_BUTTON_PRESS)
			buttonStat = BUTTON_PRESS;
		else
			buttonStat = BUTTON_UNPRESS;
		put_user(buttonStat, (int __user *)arg);
		break;
	case GPIO_ETHERNET_STS_READ:
		if(tplink_gpio_ethernet_led_get()>0)
			buttonStat = BUTTON_PRESS;
		else
			buttonStat = BUTTON_UNPRESS;
			put_user(buttonStat, (int __user *)arg);
		break;
	default:
		printk("Don't use the gpio pin: %d\n", req);
		return -1;
	}
	return 0;
}
#endif

int tplink_gpio_open(struct inode *inode, struct file *file)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	MOD_INC_USE_COUNT;
#else
	try_module_get(THIS_MODULE);
#endif
	return 0;
}

int tplink_gpio_release(struct inode *inode, struct file *file)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	MOD_DEC_USE_COUNT;
#else
	module_put(THIS_MODULE);
#endif
	return 0;
}

struct file_operations tplink_gpio_fops =
{
	owner:		THIS_MODULE,
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,35)
#if defined (CONFIG_RALINK_GPIO_IMPROVE_TPLINK)	
	unlocked_ioctl: tplink_gpio_ioctl,
#endif
#else
#if defined (CONFIG_RALINK_GPIO_IMPROVE_TPLINK)	
	ioctl:		tplink_gpio_ioctl,
#endif
#endif
	open:		tplink_gpio_open,
	release:	tplink_gpio_release,
};

static void tplink_gpio_common_init(void)
{
	tplink_gpio_mode_reg_set();
}

int __init tplink_gpio_init(void)
{

#ifdef  CONFIG_DEVFS_FS
	if (devfs_register_chrdev(tplink_gpio_major, TPLINK_GPIO_DEVNAME,
				&tplink_gpio_fops)) {
		printk(KERN_ERR NAME ": unable to register character device\n");
		return -EIO;
	}
	devfs_handle = devfs_register(NULL, TPLINK_GPIO_DEVNAME,
			DEVFS_FL_DEFAULT, tplink_gpio_major, 0,
			S_IFCHR | S_IRUGO | S_IWUGO, &tplink_gpio_fops, NULL);
#else
	int r = 0;
	r = register_chrdev(tplink_gpio_major, TPLINK_GPIO_DEVNAME,
			&tplink_gpio_fops);
	if (r < 0) {
		printk(KERN_ERR NAME ": unable to register character device\n");
		return r;
	}
	if (tplink_gpio_major == 0) {
		tplink_gpio_major = r;
		printk(KERN_DEBUG NAME ": got dynamic major %d\n", r);
	}
#endif	

       tplink_gpio_common_init();

	printk("Ralink gpio driver initialized\n");
	return 0;
}

void __exit tplink_gpio_exit(void)
{
#ifdef  CONFIG_DEVFS_FS
	devfs_unregister_chrdev(tplink_gpio_major, TPLINK_GPIO_DEVNAME);
	devfs_unregister(devfs_handle);
#else
	unregister_chrdev(tplink_gpio_major, TPLINK_GPIO_DEVNAME);
#endif

	//config these pins to normal mode
	*(volatile u32 *)(RALINK_REG_GPIOMODE) &= ~RALINK_GPIOMODE_DFT;
	printk("Ralink gpio driver exited\n");
}
		
module_init(tplink_gpio_init);
module_exit(tplink_gpio_exit);


